/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.SFPSettingsInformation;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusEventText;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.AusSystemEventLog;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.rsct.rmc.McResourceClass;
import com.ibm.rsct.rmc.McSession;
import com.ibm.rsct.rmc.McSessionEndedCB;
import com.ibm.rsct.rmcjni.McClassActionRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CtUint32;
import com.ibm.rsct.util.CuException;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.util.Date;
import java.util.Vector;

public class SFPSettings
extends MObjectImpl {
    private static final String TRACE_MASKD = "JSFPSETD";
    private static final String TRACE_MASKF = "JSFPSETF";
    private static final String TRACE_MASKT = "JSFPSETT";
    private static final ClassLogInfo _logInfo = new ClassLogInfo(-88, 106, "SFPSettings");
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    private static final String ENABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "ENABLED_LBL", "Enabled");
    private static final String DISABLED_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "DISABLED_LBL", "Disabled");
    private static final String UNKNOWN_LABEL = HSCResourceBundleUtil.getMessage("SFPResourceBundle", "UNKNOWN_LBL", "Unknown");
    private static SessionEndedHandler _sessionEndedHandler = new SessionEndedHandler();
    private static McResourceClass _sfpResource = null;
    private static final Object SESSION_CREATION_LOCK = new Object();
    private static boolean _retrying = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateSession() {
        Object object = SESSION_CREATION_LOCK;
        synchronized (object) {
            _sfpResource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static McResourceClass getResourceClass() throws SFPException {
        Object object = SESSION_CREATION_LOCK;
        synchronized (object) {
            if (_sfpResource == null) {
                try {
                    Trace.trace(TRACE_MASKD, "SFPSettings.getResourceClass() about to new-up a McSession");
                    McSession mcSession = new McSession((McSessionEndedCB)_sessionEndedHandler, (Object)new Date());
                    _sfpResource = new McResourceClass(mcSession, "IBM.Sfp");
                }
                catch (CuException cuException) {
                    SFPSettings.invalidateSession();
                    Trace.trace(TRACE_MASKF, "SFPSettings.getResourceClass() caught: " + (Object)((Object)cuException));
                    if (cuException.getErrorId() == 2) {
                        if (_retrying) {
                            _retrying = false;
                            throw new SFPException("0021", new Exception(cuException.getMessage()));
                        }
                        _retrying = true;
                        Trace.trace(TRACE_MASKF, "SFPSettings.getResourceClass() retrying");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SFPSettings.getResourceClass();
                    }
                    throw new SFPException("0021", new Exception(cuException.getMessage()));
                }
            }
            return _sfpResource;
        }
    }

    public SFPSettings(String string) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> SFPSettings.SFPSettings()");
        this.setKey(string);
        Trace.trace(TRACE_MASKT, "<- SFPSettings.SFPSettings()");
    }

    public static String getClassName() {
        Trace.trace(TRACE_MASKT, "-> SFPSettings.getClassName()");
        Trace.trace(TRACE_MASKT, "<- SFPSettings.getClassName()");
        return HSCResourceBundleUtil.getMessage("SFPResourceBundle", "SFP_SETTINGS", "Service Focal Point Settings");
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        Trace.trace(TRACE_MASKT, "-> SFPSettings.getInstance()");
        String string = mOXReference.getKey();
        SFPSettings sFPSettings = new SFPSettings(string);
        Trace.trace(TRACE_MASKT, "<- SFPSettings.getInstance()");
        return sFPSettings;
    }

    public static synchronized SFPSettingsInformation getSettingsInformation() throws SFPException {
        Trace.trace(TRACE_MASKT, "->SFPSettings.getSettingsInformation()");
        Vector vector = null;
        try {
            vector = SFPUtil.getMachineInfo();
        }
        catch (SFPException sFPException) {
            new AusMicrocodeLog(_logInfo, 2, sFPException).writeEntry(null);
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getSettingsInformation() getMachineInfo() failed with exception " + sFPException);
            throw sFPException;
        }
        int n = vector == null ? 0 : vector.size();
        Trace.trace(TRACE_MASKD, "SFPSettings.getSettingsInformation() number of cecs is " + n);
        SFPSettingsInformation sFPSettingsInformation = new SFPSettingsInformation();
        sFPSettingsInformation.stateInformation = new CECStateInformation[n];
        int n2 = 0;
        while (n2 < n) {
            CECStateInformation cECStateInformation = new CECStateInformation();
            CECInfo cECInfo = (CECInfo)vector.get(n2);
            cECStateInformation.machineName = cECInfo.getCECMachineName();
            cECStateInformation.machineModelType = cECInfo.getCECModelType();
            cECStateInformation.machineSerial = cECInfo.getCECSerialNumber();
            cECStateInformation.callHomeState = SFPSettings.getSetting("getCallHome", cECStateInformation);
            cECStateInformation.surveillanceState = SFPSettings.getSetting("getSurveillance", cECStateInformation);
            cECStateInformation.surveillanceNotificationState = SFPSettings.getSetting("getSurveillanceNotification", cECStateInformation);
            sFPSettingsInformation.stateInformation[n2] = cECStateInformation;
            ++n2;
        }
        Trace.trace(TRACE_MASKD, "SFPSettings.getSettingsInformation() has retrieved settings for cecs");
        SFPSettings.getTimerValues(sFPSettingsInformation);
        Trace.trace(TRACE_MASKD, "SFPSettings.getSettingsInformation() has retrieved timers: connected(" + sFPSettingsInformation.connected + ") disconnected(" + sFPSettingsInformation.disconnected + ") interval(" + sFPSettingsInformation.interval + ")");
        Trace.trace(TRACE_MASKT, "<-SFPSettings.getSettingsInformation()");
        return sFPSettingsInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSetting(String string, CECStateInformation cECStateInformation) throws SFPException {
        Trace.trace(TRACE_MASKT, "->SFPSettings.getSetting() for getter " + string);
        String string2 = UNKNOWN_LABEL;
        try {
            CtUint32 ctUint32;
            CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[2]);
            ctStructuredData.setData(0, (CtDataType)new CtString(cECStateInformation.machineModelType));
            ctStructuredData.setData(1, (CtDataType)new CtString(cECStateInformation.machineSerial));
            McClassActionRsp[] mcClassActionRspArray = null;
            CtUint32 ctUint322 = null;
            CtUint32 ctUint323 = null;
            Object object = SESSION_CREATION_LOCK;
            synchronized (object) {
                Trace.trace(TRACE_MASKD, "SFPSettings.getSetting() Calling SFP." + string);
                mcClassActionRspArray = SFPSettings.getResourceClass().invokeAction(string, null, ctStructuredData);
            }
            if (mcClassActionRspArray == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() response is null.");
            } else if (mcClassActionRspArray.length == 0) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() response is empty.");
            } else {
                ctUint32 = mcClassActionRspArray[0].getData();
                if (ctUint32 == null || ctUint32[0] == null) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() ERROR: data is null.");
                } else {
                    ctUint323 = ctUint32[0];
                    if (ctUint323 == null) {
                        Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() ERROR: element is null.");
                    } else {
                        Trace.trace(TRACE_MASKD, "SFPSettings.getSetting() Getting Return Code from element.");
                        int n = ctUint323.getElementCount();
                        Trace.trace(TRACE_MASKD, "SFPSettings.getSetting() Size of element is " + n);
                        if (n < 1) {
                            Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() ERROR: invalid element size");
                        } else {
                            ctUint322 = (CtUint32)ctUint323.getData(0);
                            Trace.trace(TRACE_MASKD, "SFPSettings.getSetting() rc=" + ctUint322);
                        }
                    }
                }
            }
            if (ctUint322 == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() Error, ReturnCode was null");
            } else if (ctUint322.getJniData() > 0) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getSetting() Error, ReturnCode from " + string + " was " + ctUint322.getJniData());
            } else {
                ctUint32 = (CtUint32)ctUint323.getData(1);
                Trace.trace(TRACE_MASKD, "SFPSettings::getSetting() result=" + ctUint32);
                if (ctUint32 == null || ctUint32.getJniData() > 1 || ctUint32.getJniData() < 0) {
                    string2 = UNKNOWN_LABEL;
                } else if (ctUint32.getJniData() == 0) {
                    string2 = DISABLED_LABEL;
                } else if (ctUint32.getJniData() == 1) {
                    string2 = ENABLED_LABEL;
                }
            }
        }
        catch (CuException cuException) {
            SFPSettings.invalidateSession();
            SFPException sFPException = new SFPException("0021", new Exception(cuException.getMessage()));
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getSetting() for settingsGetter " + string + " with CuException");
            throw sFPException;
        }
        catch (SFPException sFPException) {
            SFPSettings.invalidateSession();
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getSetting() for settingsGetter " + string + " with SFPException");
            throw sFPException;
        }
        catch (Throwable throwable) {
            SFPException sFPException = new SFPException("0021", throwable);
            new AusMicrocodeLog(_logInfo, 1, throwable).writeEntry(null);
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getSetting() for settingsGetter " + string + " with Throwable");
            throw sFPException;
        }
        Trace.trace(TRACE_MASKT, "<-SFPSettings.getSetting() for getter " + string + " state is " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTimerValues(SFPSettingsInformation sFPSettingsInformation) throws SFPException {
        Trace.trace(TRACE_MASKT, "->SFPSettings.getTimerValues()");
        try {
            McClassActionRsp[] mcClassActionRspArray = null;
            CtUint32 ctUint32 = null;
            CtStructuredData ctStructuredData = null;
            Object object = SESSION_CREATION_LOCK;
            synchronized (object) {
                Trace.trace(TRACE_MASKD, "SFPSettings.getTimerValues() Calling getSurvTimers");
                mcClassActionRspArray = SFPSettings.getResourceClass().invokeAction("getSurvTimers", null, null);
            }
            if (mcClassActionRspArray == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() response is null.");
            } else if (mcClassActionRspArray.length == 0) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() response is empty.");
            } else {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray == null || ctStructuredDataArray[0] == null) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() ERROR: data is null.");
                } else {
                    ctStructuredData = ctStructuredDataArray[0];
                    if (ctStructuredData == null) {
                        Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() ERROR: element is null.");
                    } else {
                        Trace.trace(TRACE_MASKD, "SFPSettings.getTimerValues() Getting Return Code from element.");
                        int n = ctStructuredData.getElementCount();
                        Trace.trace(TRACE_MASKD, "SFPSettings.getTimerValues() Size of element is " + n);
                        if (n < 1) {
                            Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() ERROR: invalid element size");
                        } else {
                            ctUint32 = (CtUint32)ctStructuredData.getData(0);
                            Trace.trace(TRACE_MASKD, "SFPSettings.getTimerValues() rc=" + ctUint32);
                        }
                    }
                }
            }
            if (ctUint32 == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() Error, ReturnCode was null");
            } else if (ctUint32.getJniData() > 0) {
                Trace.trace(TRACE_MASKF, "SFPSettings.getTimerValues() Error, ReturnCode was " + ctUint32.getJniData());
            } else {
                sFPSettingsInformation.connected = ((CtUint32)ctStructuredData.getData(1)).getJniData();
                sFPSettingsInformation.disconnected = ((CtUint32)ctStructuredData.getData(2)).getJniData();
                sFPSettingsInformation.interval = ((CtUint32)ctStructuredData.getData(3)).getJniData();
            }
        }
        catch (CuException cuException) {
            SFPSettings.invalidateSession();
            SFPException sFPException = new SFPException("0021", new Exception(cuException.getMessage()));
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getTimerValues() with CuException");
            throw sFPException;
        }
        catch (SFPException sFPException) {
            SFPSettings.invalidateSession();
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getTimerValues() with SFPException");
            throw sFPException;
        }
        catch (Throwable throwable) {
            SFPException sFPException = new SFPException("0021", throwable);
            new AusMicrocodeLog(_logInfo, 1, throwable).writeEntry(null);
            Trace.trace(TRACE_MASKT, "<-SFPSettings.getTimerValues() with Throwable");
            throw sFPException;
        }
        Trace.trace(TRACE_MASKT, "<-SFPSettings.getTimerValues(): connected(" + sFPSettingsInformation.connected + ") disconnected(" + sFPSettingsInformation.disconnected + ") interval(" + sFPSettingsInformation.interval + ")");
    }

    public static void setSettingsInformation(SFPSettingsInformation sFPSettingsInformation) throws SFPException {
        Trace.trace(TRACE_MASKT, "->SFPSettings.setSettingsInformation()");
        CECStateInformation[] cECStateInformationArray = sFPSettingsInformation.stateInformation;
        boolean bl = false;
        int n = 0;
        while (n < cECStateInformationArray.length) {
            CECStateInformation cECStateInformation = sFPSettingsInformation.stateInformation[n];
            Trace.trace(TRACE_MASKD, "SFPSettings.setSettingsInformation() at index " + n + " is " + cECStateInformation);
            boolean bl2 = SFPSettings.setSetting("setCallHome", cECStateInformation, cECStateInformation.callHomeState);
            boolean bl3 = SFPSettings.setSetting("setSurveillance", cECStateInformation, cECStateInformation.surveillanceState);
            boolean bl4 = SFPSettings.setSetting("setSurveillanceNotification", cECStateInformation, cECStateInformation.surveillanceNotificationState);
            bl = bl || bl2 || bl3 || bl4;
            ++n;
        }
        boolean bl5 = bl = SFPSettings.setTimerValues(sFPSettingsInformation) || bl;
        if (bl) {
            Trace.trace(TRACE_MASKT, "<-SFPSettings.setSettingsInformation() One or more Error Return Codes Detected saving settings... Throwing SFP Exception");
            throw new SFPException("0022");
        }
        Trace.trace(TRACE_MASKT, "<-SFPSettings.setSettingsInformation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setSetting(String string, CECStateInformation cECStateInformation, String string2) throws SFPException {
        boolean bl;
        block21: {
            Trace.trace(TRACE_MASKT, "->SFPSettings.setSetting() for setter " + string + " and state " + string2);
            bl = false;
            try {
                Object object;
                Object[] objectArray;
                if (string2.equals(UNKNOWN_LABEL)) break block21;
                CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[3]);
                ctStructuredData.setData(0, (CtDataType)new CtString(cECStateInformation.machineModelType));
                ctStructuredData.setData(1, (CtDataType)new CtString(cECStateInformation.machineSerial));
                if (string2.equals(DISABLED_LABEL)) {
                    ctStructuredData.setData(2, (CtDataType)new CtInt32(0));
                    Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() setting machine state=0 (DISABLED)");
                } else {
                    ctStructuredData.setData(2, (CtDataType)new CtInt32(1));
                    Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() setting machine state=1 (ENABLED)");
                }
                Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() Calling SFP." + string);
                McClassActionRsp[] mcClassActionRspArray = null;
                Object object2 = SESSION_CREATION_LOCK;
                synchronized (object2) {
                    mcClassActionRspArray = SFPSettings.getResourceClass().invokeAction(string, null, ctStructuredData);
                }
                CtUint32 ctUint32 = null;
                if (mcClassActionRspArray == null) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() ERROR: response is null.");
                } else {
                    objectArray = mcClassActionRspArray[0].getData();
                    if (objectArray == null || objectArray[0] == null) {
                        Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() ERROR: data is null.");
                    } else {
                        object = objectArray[0];
                        if (object == null) {
                            Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() ERROR: element is null.");
                        } else {
                            Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() Getting Return Code from element.");
                            int n = object.getElementCount();
                            Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() Size of element is " + n);
                            if (n < 1) {
                                Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() ERROR: invalid element size");
                            } else {
                                ctUint32 = (CtUint32)object.getData(0);
                                Trace.trace(TRACE_MASKD, "SFPSettings.setSetting() Sfp.setCallHome rc=" + ctUint32);
                            }
                        }
                    }
                }
                if (ctUint32 == null) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() Error, ReturnCode from setCallHome was null");
                    bl = true;
                } else if (ctUint32.getJniData() > 0) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.setSetting() Error, ReturnCode from setCallHome was " + ctUint32.getJniData());
                    bl = true;
                } else {
                    objectArray = new String[]{cECStateInformation.machineName, string2};
                    object = new AusSystemEventLog(new AusEventText(2067, (String[])objectArray), "SFPSettings");
                    ((AusSystemEventLog)((Object)object)).writeEntry();
                }
            }
            catch (CuException cuException) {
                SFPSettings.invalidateSession();
                SFPException sFPException = new SFPException("0022", new Exception(cuException.getMessage()));
                Trace.trace(TRACE_MASKT, "<-SFPSettings.setSetting() with CuException");
                throw sFPException;
            }
            catch (SFPException sFPException) {
                new AusMicrocodeLog(_logInfo, 2, sFPException).writeEntry(null);
                Trace.trace(TRACE_MASKT, "<-SFPSettings.setSetting() with SFPException");
                throw sFPException;
            }
            catch (Throwable throwable) {
                SFPException sFPException = new SFPException("0022", throwable);
                new AusMicrocodeLog(_logInfo, 1, throwable).writeEntry(null);
                Trace.trace(TRACE_MASKT, "<-SFPSettings.setSetting() with Throwable");
                throw sFPException;
            }
        }
        Trace.trace(TRACE_MASKT, "<-SFPSettings.setSetting() returning with " + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setTimerValues(SFPSettingsInformation sFPSettingsInformation) throws SFPException {
        Trace.trace(TRACE_MASKT, "->SFPSettings.setTimerValues()");
        boolean bl = false;
        try {
            Object object;
            Object[] objectArray;
            CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[3]);
            ctStructuredData.setData(0, (CtDataType)new CtUint32(sFPSettingsInformation.connected));
            ctStructuredData.setData(1, (CtDataType)new CtUint32(sFPSettingsInformation.disconnected));
            ctStructuredData.setData(2, (CtDataType)new CtUint32(sFPSettingsInformation.interval));
            Trace.trace(TRACE_MASKD, "SFPSettings.setTimerValues() calling setSurvTimers");
            McClassActionRsp[] mcClassActionRspArray = null;
            Object object2 = SESSION_CREATION_LOCK;
            synchronized (object2) {
                mcClassActionRspArray = SFPSettings.getResourceClass().invokeAction("setSurvTimers", null, ctStructuredData);
            }
            CtUint32 ctUint32 = null;
            if (mcClassActionRspArray == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() ERROR: response is null.");
            } else {
                objectArray = mcClassActionRspArray[0].getData();
                if (objectArray == null || objectArray[0] == null) {
                    Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() ERROR: data is null.");
                } else {
                    object = objectArray[0];
                    if (object == null) {
                        Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() ERROR: element is null.");
                    } else {
                        Trace.trace(TRACE_MASKD, "SFPSettings.setTimerValues() Getting Return Code from element.");
                        int n = object.getElementCount();
                        Trace.trace(TRACE_MASKD, "SFPSettings.setTimerValues() Size of element is " + n);
                        if (n < 1) {
                            Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() ERROR: invalid element size");
                        } else {
                            ctUint32 = (CtUint32)object.getData(0);
                            Trace.trace(TRACE_MASKD, "SFPSettings.setTimerValues() Sfp.setSurvTimers rc=" + ctUint32);
                        }
                    }
                }
            }
            if (ctUint32 == null) {
                Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() Error, ReturnCode from setSurvTimers was null");
                bl = true;
            } else if (ctUint32.getJniData() > 0) {
                Trace.trace(TRACE_MASKF, "SFPSettings.setTimerValues() Error, ReturnCode from setSurvTimers was " + ctUint32.getJniData());
                bl = true;
            } else {
                objectArray = new String[]{Integer.toString(sFPSettingsInformation.connected), Integer.toString(sFPSettingsInformation.disconnected), Integer.toString(sFPSettingsInformation.interval)};
                object = new AusSystemEventLog(new AusEventText(2067, (String[])objectArray), "SFPSettings");
                ((AusSystemEventLog)((Object)object)).writeEntry();
            }
        }
        catch (CuException cuException) {
            SFPSettings.invalidateSession();
            SFPException sFPException = new SFPException("0022", new Exception(cuException.getMessage()));
            Trace.trace(TRACE_MASKT, "<-SFPSettings.setTimerValues() with CuException");
            throw sFPException;
        }
        catch (SFPException sFPException) {
            new AusMicrocodeLog(_logInfo, 2, sFPException).writeEntry(null);
            Trace.trace(TRACE_MASKT, "<-SFPSettings.setSetTimerValues() with SFPException");
            throw sFPException;
        }
        catch (Throwable throwable) {
            SFPException sFPException = new SFPException("0022", throwable);
            new AusMicrocodeLog(_logInfo, 1, throwable).writeEntry(null);
            Trace.trace(TRACE_MASKT, "<-SFPSettings.setTimerValues() with Throwable");
            throw sFPException;
        }
        Trace.trace(TRACE_MASKT, "<-SFPSettings.setTimerValues() returning with " + bl);
        return bl;
    }

    static class SessionEndedHandler
    implements McSessionEndedCB {
        SessionEndedHandler() {
        }

        public void sessionEnded(Object object) {
            Trace.trace(SFPSettings.TRACE_MASKF, "SFPSettings.SessionEndedHandler.sessionEnded() with object: " + object.toString());
            SFPSettings.invalidateSession();
            try {
                SFPSettings.getResourceClass();
            }
            catch (SFPException sFPException) {
                Trace.trace(SFPSettings.TRACE_MASKF, "SFPSettings.SessionEndedHandler.sessionEnded() caught: " + sFPException);
            }
        }

        public void sessionInterrupted(Object object) {
            Trace.trace(SFPSettings.TRACE_MASKF, "SFPSettings.SessionEndedHandler.sessionInterrupted() with object: " + object.toString());
            SFPSettings.invalidateSession();
            try {
                SFPSettings.getResourceClass();
            }
            catch (SFPException sFPException) {
                Trace.trace(SFPSettings.TRACE_MASKF, "SFPSettings.SessionEndedHandler.sessionInterrupted() caught: " + sFPException);
            }
        }
    }
}

